import torch.nn as nn
import torch.nn.functional as F

__all__ = ['vgg16','vgg19']
config = {'VGG16':[96,96,'M',128,128,'M',256,256,256,'M',512,512,512,'M',512,512,512,'M'],
          'VGG19':[96,96,'M',128,128,'M',256,256,256,256,'M',512,512,512,512,'M',512,512,512,512,'M']
          }

class VGG(nn.Module):
    def __init__(self,net_name,num_classes):
        super(VGG,self).__init__()
    
        self.features = self._make_layers(config[net_name])
    
        self.classifier = nn.Sequential(
            nn.Dropout(0.3),
            nn.Linear(512,4096),
            nn.ReLU(True),
            nn.Dropout(0.3),
            nn.Linear(4096,4096),
            nn.ReLU(True),
            nn.Linear(4096, num_classes),
        )

    def forward(self, x):
        x = self.features(x)
        x = x.view(x.size(0), -1)
        x = self.classifier(x)
        return x

    def _make_layers(self,cfg):
        layers = []
        in_channels = 3
        for v in cfg:
            if v == 'M':
                layers += [nn.MaxPool2d(kernel_size=2,stride=2)]
            else:
                layers += [nn.Conv2d(in_channels, v, kernel_size=3, padding=1),
                           nn.BatchNorm2d(v),
                           nn.ReLU(inplace=True)]
                in_channels = v

        return nn.Sequential(*layers)


def vgg16():
    return VGG('VGG16',num_classes = 100)

def vgg19():
    return VGG('VGG19',num_classes = 100)